<?php
function openrouter_chat(string $question, string $systemPrompt, string $apiKey, string $model, string $extraContext=''): ?string {
  if (!$apiKey) return null;

  $user = $question;
  if (trim($extraContext) !== '') {
    $user = "اطلاعات زمینه (از دیتابیس/سایت):\n".$extraContext."\n\nسؤال کاربر:\n".$question;
  }

  $payload = [
    'model' => $model ?: 'google/gemma-2-9b-it',
    'messages' => [
      ['role'=>'system','content'=>$systemPrompt],
      ['role'=>'user','content'=>$user],
    ],
  ];

  $ch = curl_init('https://openrouter.ai/api/v1/chat/completions');
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
      'Authorization: Bearer '.$apiKey,
      'Content-Type: application/json',
    ],
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_TIMEOUT => 30,
  ]);
  $res = curl_exec($ch);
  curl_close($ch);
  if (!$res) return null;

  $json = json_decode($res, true);
  return $json['choices'][0]['message']['content'] ?? null;
}
