<?php
$page_title='گزارش‌ها (Analytics)';
require __DIR__.'/_init.php';

function dt_range(): array {
  $from = trim((string)($_GET['from'] ?? ''));
  $to   = trim((string)($_GET['to'] ?? ''));
  if ($from==='') $from = date('Y-m-d', strtotime('-30 days')).' 00:00:00';
  if ($to==='')   $to   = date('Y-m-d').' 23:59:59';
  // allow date only
  if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$from)) $from .= ' 00:00:00';
  if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$to))   $to   .= ' 23:59:59';
  return [$from,$to];
}
[$from,$to] = dt_range();

$report = $_GET['report'] ?? 'top_questions';
$export = ($_GET['export'] ?? '') === 'csv';

function csv_out(string $filename, array $rows, array $headers){
  header('Content-Type: text/csv; charset=utf-8');
  header('Content-Disposition: attachment; filename="'.$filename.'"');
  $out = fopen('php://output','w');
  // UTF-8 BOM for Excel
  fprintf($out, chr(0xEF).chr(0xBB).chr(0xBF));
  fputcsv($out, $headers);
  foreach($rows as $r) fputcsv($out, $r);
  fclose($out);
  exit;
}

if ($export) {
  if ($report === 'top_questions') {
    $st = $pdo->prepare("SELECT question, COUNT(*) cnt
      FROM chat_logs
      WHERE created_at BETWEEN ? AND ?
      GROUP BY question
      ORDER BY cnt DESC
      LIMIT 200");
    $st->execute([$from,$to]);
    $rows = [];
    while($x=$st->fetch()){
      $rows[] = [$x['question'], (int)$x['cnt']];
    }
    csv_out('top_questions.csv', $rows, ['question','count']);
  }

  if ($report === 'top_companies') {
    $st = $pdo->prepare("SELECT c.name, c.is_vip, c.vip_level, COUNT(*) cnt
      FROM chat_logs l
      JOIN companies c ON c.id=l.company_id
      WHERE l.company_id IS NOT NULL AND l.created_at BETWEEN ? AND ?
      GROUP BY l.company_id
      ORDER BY cnt DESC
      LIMIT 200");
    $st->execute([$from,$to]);
    $rows=[];
    while($x=$st->fetch()){
      $rows[] = [$x['name'], (int)$x['cnt'], (int)$x['is_vip'], (int)$x['vip_level']];
    }
    csv_out('top_companies.csv', $rows, ['company','count','is_vip','vip_level']);
  }

  if ($report === 'sources') {
    $st = $pdo->prepare("SELECT source, COUNT(*) cnt
      FROM chat_logs
      WHERE created_at BETWEEN ? AND ?
      GROUP BY source
      ORDER BY cnt DESC");
    $st->execute([$from,$to]);
    $rows=[];
    while($x=$st->fetch()){
      $rows[] = [$x['source'] ?: '—', (int)$x['cnt']];
    }
    csv_out('sources.csv', $rows, ['source','count']);
  }

  if ($report === 'unanswered') {
    $st = $pdo->prepare("SELECT question, COUNT(*) cnt
      FROM chat_logs
      WHERE created_at BETWEEN ? AND ? AND (source='none' OR intent='no_answer')
      GROUP BY question
      ORDER BY cnt DESC
      LIMIT 200");
    $st->execute([$from,$to]);
    $rows=[];
    while($x=$st->fetch()){
      $rows[] = [$x['question'], (int)$x['cnt']];
    }
    csv_out('unanswered.csv', $rows, ['question','count']);
  }

  // default
  csv_out('report.csv', [], ['empty']);
}

function nav_link(string $title, string $key, string $cur, string $from, string $to){
  $cls = $key===$cur ? 'p-btn p-btn--primary' : 'p-btn';
  echo '<a class="'.h($cls).'" href="analytics.php?report='.h($key).'&from='.urlencode($from).'&to='.urlencode($to).'">'.h($title).'</a>';
}

require __DIR__.'/_layout_top.php';
?>
<div class="p-card">
  <h3>بازه زمانی</h3>
  <form class="p-row" method="get">
    <input type="hidden" name="report" value="<?= h($report) ?>">
    <input class="p-input" style="max-width:220px" name="from" value="<?= h($from) ?>" placeholder="YYYY-MM-DD یا YYYY-MM-DD HH:MM:SS">
    <input class="p-input" style="max-width:220px" name="to" value="<?= h($to) ?>" placeholder="YYYY-MM-DD یا YYYY-MM-DD HH:MM:SS">
    <button class="p-btn p-btn--primary">اعمال</button>
    <a class="p-btn" href="analytics.php">۳۰ روز اخیر</a>
  </form>
</div>

<div class="p-card">
  <h3>گزارش‌ها</h3>
  <div class="p-actions">
    <?php
      nav_link('پرتکرارترین سوالات','top_questions',$report,$from,$to);
      nav_link('شرکت‌های پربازدید','top_companies',$report,$from,$to);
      nav_link('تقسیم منابع پاسخ','sources',$report,$from,$to);
      nav_link('سوالات بی‌پاسخ','unanswered',$report,$from,$to);
    ?>
    <a class="p-btn" href="analytics.php?report=<?=h($report)?>&from=<?=urlencode($from)?>&to=<?=urlencode($to)?>&export=csv">خروجی CSV</a>
  </div>
  <div class="p-help">منبع پاسخ = FAQ / Company / Site / AI / none</div>
</div>

<?php
if ($report === 'top_questions') {
  $st = $pdo->prepare("SELECT question, COUNT(*) cnt
    FROM chat_logs
    WHERE created_at BETWEEN ? AND ?
    GROUP BY question
    ORDER BY cnt DESC
    LIMIT 50");
  $st->execute([$from,$to]);
  $rows = $st->fetchAll();
  echo '<div class="p-card"><h3>پرتکرارترین سوالات</h3><table class="p-table"><thead><tr><th>سؤال</th><th>تعداد</th></tr></thead><tbody>';
  foreach($rows as $x){
    echo '<tr><td>'.h($x['question']).'</td><td>'.(int)$x['cnt'].'</td></tr>';
  }
  echo '</tbody></table></div>';
}

if ($report === 'top_companies') {
  $st = $pdo->prepare("SELECT c.id, c.name, c.is_vip, c.vip_level, COUNT(*) cnt
    FROM chat_logs l
    JOIN companies c ON c.id=l.company_id
    WHERE l.company_id IS NOT NULL AND l.created_at BETWEEN ? AND ?
    GROUP BY l.company_id
    ORDER BY cnt DESC
    LIMIT 50");
  $st->execute([$from,$to]);
  $rows = $st->fetchAll();
  echo '<div class="p-card"><h3>شرکت‌های پربازدید</h3><table class="p-table"><thead><tr><th>شرکت</th><th>تعداد</th><th>VIP</th><th></th></tr></thead><tbody>';
  foreach($rows as $x){
    $vip = ((int)$x['is_vip']===1) ? '⭐ سطح '.(int)$x['vip_level'] : '—';
    echo '<tr><td><b>'.h($x['name']).'</b></td><td>'.(int)$x['cnt'].'</td><td>'.h($vip).'</td><td><a class="p-btn p-btn--primary" href="companies.php?mode=edit&id='.(int)$x['id'].'">باز کردن</a></td></tr>';
  }
  echo '</tbody></table></div>';
}

if ($report === 'sources') {
  $st = $pdo->prepare("SELECT source, COUNT(*) cnt
    FROM chat_logs
    WHERE created_at BETWEEN ? AND ?
    GROUP BY source
    ORDER BY cnt DESC");
  $st->execute([$from,$to]);
  $rows = $st->fetchAll();
  echo '<div class="p-card"><h3>تقسیم منابع پاسخ</h3><table class="p-table"><thead><tr><th>منبع</th><th>تعداد</th></tr></thead><tbody>';
  foreach($rows as $x){
    echo '<tr><td>'.h($x['source'] ?: '—').'</td><td>'.(int)$x['cnt'].'</td></tr>';
  }
  echo '</tbody></table></div>';
}

if ($report === 'unanswered') {
  $st = $pdo->prepare("SELECT question, COUNT(*) cnt
    FROM chat_logs
    WHERE created_at BETWEEN ? AND ? AND (source='none' OR intent='no_answer')
    GROUP BY question
    ORDER BY cnt DESC
    LIMIT 50");
  $st->execute([$from,$to]);
  $rows = $st->fetchAll();
  echo '<div class="p-card"><h3>سوالات بی‌پاسخ / نیازمند تقویت دیتابیس</h3><table class="p-table"><thead><tr><th>سؤال</th><th>تعداد</th></tr></thead><tbody>';
  foreach($rows as $x){
    echo '<tr><td>'.h($x['question']).'</td><td>'.(int)$x['cnt'].'</td></tr>';
  }
  echo '</tbody></table></div>';
}
?>

<?php require __DIR__.'/_layout_bottom.php'; ?>
