<?php
$page_title = 'مدیریت شرکت‌ها';
require __DIR__ . '/_init.php';

/* Helpers */
function fetch_company(PDO $pdo, int $id){
  $st = $pdo->prepare("SELECT * FROM companies WHERE id=?");
  $st->execute([$id]);
  return $st->fetch();
}
function fetch_company_tags(PDO $pdo, int $id): array {
  $st = $pdo->prepare("SELECT tag_id FROM company_tags WHERE company_id=?");
  $st->execute([$id]);
  return array_map(fn($r)=>(int)$r['tag_id'], $st->fetchAll());
}
function set_company_tags(PDO $pdo, int $id, array $tagIds): void {
  $pdo->prepare("DELETE FROM company_tags WHERE company_id=?")->execute([$id]);
  $ins = $pdo->prepare("INSERT INTO company_tags(company_id, tag_id) VALUES(?,?)");
  foreach ($tagIds as $tid) {
    $tid = (int)$tid;
    if ($tid>0) $ins->execute([$id, $tid]);
  }
}

$mode = $_GET['mode'] ?? 'list';
$id   = (int)($_GET['id'] ?? 0);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'] ?? '';

  if ($action === 'delete') {
    $did = (int)($_POST['id'] ?? 0);
    if ($did>0) {
      $pdo->prepare("DELETE FROM companies WHERE id=?")->execute([$did]);
      flash_set('ok','شرکت حذف شد.');
    }
    header('Location: companies.php'); exit;
  }

  if ($action === 'save') {
    $cid = (int)($_POST['id'] ?? 0);

    $data = [
      'name' => trim((string)($_POST['name'] ?? '')),
      'name_en' => trim((string)($_POST['name_en'] ?? '')),
      'field' => trim((string)($_POST['field'] ?? '')),
      'description' => trim((string)($_POST['description'] ?? '')),
      'phone' => trim((string)($_POST['phone'] ?? '')),
      'email' => trim((string)($_POST['email'] ?? '')),
      'website' => trim((string)($_POST['website'] ?? '')),
      'city' => trim((string)($_POST['city'] ?? '')),
      'province' => trim((string)($_POST['province'] ?? '')),
      'hall' => trim((string)($_POST['hall'] ?? '')),
      'row_name' => trim((string)($_POST['row_name'] ?? '')),
      'booth' => trim((string)($_POST['booth'] ?? '')),
      'is_vip' => isset($_POST['is_vip']) ? 1 : 0,
      'vip_level' => (int)($_POST['vip_level'] ?? 0),
      'boost_enabled' => isset($_POST['boost_enabled']) ? 1 : 0,
      'boost_text' => trim((string)($_POST['boost_text'] ?? '')),
      'boost_start' => trim((string)($_POST['boost_start'] ?? '')) ?: null,
      'boost_end' => trim((string)($_POST['boost_end'] ?? '')) ?: null,
    ];

    if ($data['name'] === '') {
      flash_set('err','نام شرکت الزامی است.');
      header('Location: companies.php?mode=edit&id='.$cid); exit;
    }

    if ($cid > 0) {
      $sql = "UPDATE companies SET
        name=:name, name_en=:name_en, field=:field, description=:description,
        phone=:phone, email=:email, website=:website, city=:city, province=:province,
        hall=:hall, row_name=:row_name, booth=:booth,
        is_vip=:is_vip, vip_level=:vip_level,
        boost_enabled=:boost_enabled, boost_text=:boost_text, boost_start=:boost_start, boost_end=:boost_end
        WHERE id=:id";
      $st = $pdo->prepare($sql);
      $data['id'] = $cid;
      $st->execute($data);
      flash_set('ok','اطلاعات شرکت بروزرسانی شد.');
    } else {
      $sql = "INSERT INTO companies
        (name,name_en,field,description,phone,email,website,city,province,hall,row_name,booth,is_vip,vip_level,boost_enabled,boost_text,boost_start,boost_end)
        VALUES
        (:name,:name_en,:field,:description,:phone,:email,:website,:city,:province,:hall,:row_name,:booth,:is_vip,:vip_level,:boost_enabled,:boost_text,:boost_start,:boost_end)";
      $st = $pdo->prepare($sql);
      $st->execute($data);
      $cid = (int)$pdo->lastInsertId();
      flash_set('ok','شرکت جدید ثبت شد.');
    }

    // tags
    $tagIds = $_POST['tags'] ?? [];
    if (!is_array($tagIds)) $tagIds = [];
    set_company_tags($pdo, $cid, $tagIds);

    header('Location: companies.php?mode=edit&id='.$cid); exit;
  }
}

// List mode
$ok  = flash_get('ok');
$err = flash_get('err');

if ($mode === 'edit') {
  $company = $id ? fetch_company($pdo,$id) : null;
  $allTags = $pdo->query("SELECT * FROM tags ORDER BY name ASC")->fetchAll();
  $selected = $company ? fetch_company_tags($pdo, (int)$company['id']) : [];
  $page_title = $company ? ('ویرایش شرکت: '.$company['name']) : 'افزودن شرکت جدید';
  require __DIR__ . '/_layout_top.php';
  ?>
  <div class="p-card">
    <h3><?= h($page_title) ?></h3>
    <?php if($ok): ?><div class="p-badge p-badge--ok"><?= h($ok) ?></div><?php endif; ?>
    <?php if($err): ?><div class="p-badge p-badge--err"><?= h($err) ?></div><?php endif; ?>

    <form method="post" style="margin-top:12px">
      <input type="hidden" name="action" value="save">
      <input type="hidden" name="id" value="<?= (int)($company['id'] ?? 0) ?>">

      <div class="p-grid2">
        <div>
          <div class="p-label">نام شرکت (فارسی)*</div>
          <input class="p-input" name="name" value="<?= h($company['name'] ?? '') ?>" required>
        </div>
        <div>
          <div class="p-label">نام انگلیسی</div>
          <input class="p-input" name="name_en" value="<?= h($company['name_en'] ?? '') ?>">
        </div>
        <div>
          <div class="p-label">حوزه فعالیت</div>
          <input class="p-input" name="field" value="<?= h($company['field'] ?? '') ?>" placeholder="مثال: تجهیزات حفاری / خدمات فنی / پتروشیمی">
        </div>
        <div>
          <div class="p-label">وبسایت</div>
          <input class="p-input" name="website" value="<?= h($company['website'] ?? '') ?>" placeholder="https://...">
        </div>
      </div>

      <div class="p-label">توضیحات</div>
      <textarea class="p-textarea" name="description" placeholder="خلاصه معرفی شرکت..."><?= h($company['description'] ?? '') ?></textarea>

      <div class="p-grid2">
        <div>
          <div class="p-label">تلفن</div>
          <input class="p-input" name="phone" value="<?= h($company['phone'] ?? '') ?>">
        </div>
        <div>
          <div class="p-label">ایمیل</div>
          <input class="p-input" name="email" value="<?= h($company['email'] ?? '') ?>">
        </div>
        <div>
          <div class="p-label">استان</div>
          <input class="p-input" name="province" value="<?= h($company['province'] ?? '') ?>">
        </div>
        <div>
          <div class="p-label">شهر</div>
          <input class="p-input" name="city" value="<?= h($company['city'] ?? '') ?>">
        </div>
      </div>

      <div class="p-hr"></div>
      <h3>اطلاعات غرفه</h3>

      <div class="p-grid2">
        <div>
          <div class="p-label">سالن</div>
          <input class="p-input" name="hall" value="<?= h($company['hall'] ?? '') ?>" placeholder="مثال: A">
        </div>
        <div>
          <div class="p-label">ردیف</div>
          <input class="p-input" name="row_name" value="<?= h($company['row_name'] ?? '') ?>" placeholder="مثال: 3">
        </div>
        <div>
          <div class="p-label">شماره غرفه</div>
          <input class="p-input" name="booth" value="<?= h($company['booth'] ?? '') ?>" placeholder="مثال: A12">
        </div>
      </div>

      <div class="p-hr"></div>
      <h3>VIP و Boost</h3>

      <div class="p-grid2">
        <div>
          <label class="p-row" style="margin-top:8px">
            <input type="checkbox" name="is_vip" <?= !empty($company['is_vip']) ? 'checked' : '' ?>>
            <span>⭐ این شرکت VIP است</span>
          </label>
          <div class="p-label">سطح VIP (عدد بالاتر = اولویت بیشتر)</div>
          <input class="p-input" type="number" name="vip_level" value="<?= (int)($company['vip_level'] ?? 0) ?>">
        </div>
        <div>
          <label class="p-row" style="margin-top:8px">
            <input type="checkbox" name="boost_enabled" <?= !empty($company['boost_enabled']) ? 'checked' : '' ?>>
            <span>🚀 Boost فعال باشد</span>
          </label>
          <div class="p-label">متن کوتاه Boost</div>
          <input class="p-input" name="boost_text" value="<?= h($company['boost_text'] ?? '') ?>" placeholder="مثال: خدمات ویژه در ایام نمایشگاه">
          <div class="p-row" style="margin-top:10px">
            <div style="flex:1">
              <div class="p-label">شروع Boost (اختیاری)</div>
              <input class="p-input" name="boost_start" value="<?= h($company['boost_start'] ?? '') ?>" placeholder="YYYY-MM-DD HH:MM:SS">
            </div>
            <div style="flex:1">
              <div class="p-label">پایان Boost (اختیاری)</div>
              <input class="p-input" name="boost_end" value="<?= h($company['boost_end'] ?? '') ?>" placeholder="YYYY-MM-DD HH:MM:SS">
            </div>
          </div>
        </div>
      </div>

      <div class="p-hr"></div>
      <h3>Tagها</h3>
      <div class="p-help">برای فعال شدن پیشنهاد شرکت‌های مرتبط و گزارش‌ها، حداقل ۱ Tag برای شرکت ثبت کنید.</div>
      <div class="p-row" style="margin-top:10px">
        <select class="p-select" name="tags[]" multiple size="8" style="min-height:180px">
          <?php foreach($allTags as $t): $tid=(int)$t['id']; ?>
            <option value="<?= $tid ?>" <?= in_array($tid,$selected,true) ? 'selected' : '' ?>><?= h($t['name']) ?></option>
          <?php endforeach; ?>
        </select>
        <div style="min-width:220px">
          <a class="p-btn p-btn--primary" href="tags.php">مدیریت Tagها</a>
          <div class="p-help">اگر Tag ندارید، ابتدا در بخش Tagها چند مورد بسازید.</div>
        </div>
      </div>

      <div class="p-hr"></div>
      <div class="p-row">
        <button class="p-btn p-btn--primary" type="submit">ذخیره</button>
        <a class="p-btn" href="companies.php">بازگشت به لیست</a>
        <?php if(!empty($company['id'])): ?>
          <form method="post" onsubmit="return confirm('حذف شود؟');" style="margin:0">
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="id" value="<?= (int)$company['id'] ?>">
            <button class="p-btn p-btn--danger" type="submit">حذف شرکت</button>
          </form>
        <?php endif; ?>
      </div>
    </form>
  </div>
  <?php
  require __DIR__ . '/_layout_bottom.php';
  exit;
}

// list
$q = trim((string)($_GET['q'] ?? ''));
$vip = $_GET['vip'] ?? '';
$boost = $_GET['boost'] ?? '';
$tag = (int)($_GET['tag'] ?? 0);

$where = [];
$params = [];

if ($q !== '') {
  $where[] = "(c.name LIKE ? OR c.field LIKE ? OR c.booth LIKE ?)";
  $params += [count($params)+1 => "%$q%"];
  $params += [count($params)+1 => "%$q%"];
  $params += [count($params)+1 => "%$q%"];
}
if ($vip === '1') $where[] = "c.is_vip=1";
if ($boost === '1') $where[] = "c.boost_enabled=1";
if ($tag > 0) {
  $where[] = "EXISTS (SELECT 1 FROM company_tags ct WHERE ct.company_id=c.id AND ct.tag_id=?)";
  $params += [count($params)+1 => $tag];
}

$wsql = $where ? ("WHERE ".implode(" AND ",$where)) : "";
$sql = "SELECT c.*,
        (SELECT GROUP_CONCAT(t.name ORDER BY t.name SEPARATOR ', ')
         FROM company_tags ct JOIN tags t ON t.id=ct.tag_id WHERE ct.company_id=c.id) as tag_names
        FROM companies c
        $wsql
        ORDER BY c.is_vip DESC, c.vip_level DESC, c.boost_enabled DESC, c.id DESC
        LIMIT 200";

$st = $pdo->prepare($sql);
$st->execute(array_values($params));
$rows = $st->fetchAll();

$tags = $pdo->query("SELECT * FROM tags ORDER BY name ASC")->fetchAll();

require __DIR__ . '/_layout_top.php';
?>
<div class="p-card">
  <h3>جستجو و فیلتر</h3>
  <?php if($ok): ?><div class="p-badge p-badge--ok"><?= h($ok) ?></div><?php endif; ?>
  <?php if($err): ?><div class="p-badge p-badge--err"><?= h($err) ?></div><?php endif; ?>

  <form class="p-search" method="get" style="margin-top:10px">
    <input class="p-input" name="q" value="<?= h($q) ?>" placeholder="نام/حوزه/غرفه...">
    <select class="p-select" name="vip" style="max-width:180px">
      <option value="">VIP: همه</option>
      <option value="1" <?= $vip==='1'?'selected':'' ?>>فقط VIP</option>
    </select>
    <select class="p-select" name="boost" style="max-width:180px">
      <option value="">Boost: همه</option>
      <option value="1" <?= $boost==='1'?'selected':'' ?>>فقط Boost</option>
    </select>
    <select class="p-select" name="tag" style="max-width:240px">
      <option value="0">Tag: همه</option>
      <?php foreach($tags as $t): ?>
        <option value="<?= (int)$t['id'] ?>" <?= $tag===(int)$t['id']?'selected':'' ?>><?= h($t['name']) ?></option>
      <?php endforeach; ?>
    </select>
    <button class="p-btn p-btn--primary" type="submit">اعمال</button>
    <a class="p-btn" href="companies.php">ریست</a>
    <a class="p-btn p-btn--primary" href="companies.php?mode=edit">+ افزودن شرکت</a>
  </form>
  <div class="p-help">فعلاً 200 نتیجه آخر نمایش داده می‌شود (برای سرعت). اگر دیتابیس بزرگ شد، صفحه‌بندی اضافه می‌کنیم.</div>
</div>

<div class="p-card">
  <h3>لیست شرکت‌ها</h3>
  <table class="p-table">
    <thead><tr>
      <th>نام</th>
      <th>حوزه</th>
      <th>غرفه</th>
      <th>Tag</th>
      <th>VIP/Boost</th>
      <th></th>
    </tr></thead>
    <tbody>
      <?php foreach($rows as $c): ?>
        <tr>
          <td>
            <b><?= h($c['name']) ?></b>
            <?php if(!empty($c['website'])): ?><div><small><?= h($c['website']) ?></small></div><?php endif; ?>
          </td>
          <td><?= h($c['field'] ?? '—') ?></td>
          <td><?= h(($c['hall'] ?: '').' '.($c['booth'] ?: '')) ?: '—' ?></td>
          <td><?= h($c['tag_names'] ?? '—') ?></td>
          <td>
            <?php if((int)$c['is_vip']===1): ?><span class="p-pill">⭐ VIP <?= (int)$c['vip_level'] ?></span><?php endif; ?>
            <?php if((int)$c['boost_enabled']===1): ?><span class="p-pill">🚀 Boost</span><?php endif; ?>
          </td>
          <td style="width:140px">
            <a class="p-btn p-btn--primary" href="companies.php?mode=edit&id=<?= (int)$c['id'] ?>">ویرایش</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php require __DIR__ . '/_layout_bottom.php'; ?>
