<?php
require __DIR__ . '/_auth.php';
require __DIR__ . '/../includes/bootstrap.php';

$stats = [
  'companies' => (int)$pdo->query("SELECT COUNT(*) c FROM companies")->fetch()['c'],
  'vip'       => (int)$pdo->query("SELECT COUNT(*) c FROM companies WHERE is_vip=1")->fetch()['c'],
  'tags'      => (int)$pdo->query("SELECT COUNT(*) c FROM tags")->fetch()['c'],
  'faq'       => (int)$pdo->query("SELECT COUNT(*) c FROM faq")->fetch()['c'],
  'pages'     => (int)$pdo->query("SELECT COUNT(*) c FROM site_data")->fetch()['c'],
  'logs'      => (int)$pdo->query("SELECT COUNT(*) c FROM chat_logs")->fetch()['c'],
];
$lastPages = $pdo->query("SELECT title,url,LEFT(content,180) snippet,updated_at FROM site_data ORDER BY updated_at DESC LIMIT 5")->fetchAll();
$sitemap = setting_get($pdo,'sitemap_url','https://oilshow-khz.com/sitemap_index.xml');
?>
<!doctype html><html lang="fa" dir="rtl"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>داشبورد</title>
<link rel="stylesheet" href="../assets/css/panel.css">
</head><body>
<div class="p-topbar">
  <div class="p-topbar__title">داشبورد چت‌بات نمایشگاه نفت</div>
  <a class="p-btn" href="logout.php">خروج</a>
</div>

<div class="p-wrap">
  <div class="p-grid">
    <div class="p-card"><div class="p-kpi">شرکت‌ها</div><div class="p-kpi__n"><?= $stats['companies'] ?></div></div>
    <div class="p-card"><div class="p-kpi">VIP</div><div class="p-kpi__n"><?= $stats['vip'] ?></div></div>
    <div class="p-card"><div class="p-kpi">Tag</div><div class="p-kpi__n"><?= $stats['tags'] ?></div></div>
    <div class="p-card"><div class="p-kpi">FAQ</div><div class="p-kpi__n"><?= $stats['faq'] ?></div></div>
    <div class="p-card"><div class="p-kpi">صفحات سایت</div><div class="p-kpi__n"><?= $stats['pages'] ?></div></div>
    <div class="p-card"><div class="p-kpi">لاگ سوالات</div><div class="p-kpi__n"><?= $stats['logs'] ?></div></div>
  </div>

  <div class="p-card">
    <h3>منو</h3>
    <div class="p-actions">
      <a class="p-btn p-btn--primary" href="companies.php">مدیریت شرکت‌ها</a>
      <a class="p-btn p-btn--primary" href="tags.php">مدیریت Tagها</a>
      <a class="p-btn p-btn--primary" href="faq.php">FAQ</a>
      <a class="p-btn p-btn--primary" href="crawler.php">Crawler سایت</a>
      <a class="p-btn p-btn--primary" href="settings.php">تنظیمات</a>
      <a class="p-btn" href="analytics.php">گزارش‌ها</a>
      <a class="p-btn" href="logs.php">لاگ‌ها</a>
    </div>
  </div>

  <div class="p-card">
    <h3>خلاصه دیتای سایت</h3>
    <div class="p-muted">Sitemap: <?= htmlspecialchars($sitemap) ?></div>
    <table class="p-table">
      <thead><tr><th>عنوان</th><th>Snippet</th><th>آخرین بروزرسانی</th></tr></thead>
      <tbody>
      <?php foreach($lastPages as $p): ?>
        <tr>
          <td><a class="p-link" href="<?= htmlspecialchars($p['url']) ?>" target="_blank"><?= htmlspecialchars($p['title'] ?: '—') ?></a></td>
          <td><?= htmlspecialchars($p['snippet']) ?>...</td>
          <td><?= htmlspecialchars($p['updated_at']) ?></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
</body></html>
